const adminRoutes = [
  {
    name: 'dashboard',
    icon: 'dashboard',
    url: 'dashboard',
    id: 'dashboard',
    type: 'single',
  },
  {
    name: 'calendar',
    icon: 'calendar',
    url: 'calendar',
    id: 'calendar',
    type: 'single',
  },
  {
    name: 'pos',
    icon: 'pos',
    url: 'pos-system',
    id: 'pos',
    type: 'single',
  },
  {
    name: 'warehouse',
    icon: 'warehouse',
    url: 'warehouse',
    id: 'warehouse',
    type: 'single',
  },
  {
    name: 'order.management',
    id: 'order_management',
    type: 'group',
    menus: [
      {
        name: 'orders',
        id: 'orders',
        icon: 'orders',
        type: 'parent',
        children: [
          {
            name: 'all',
            url: 'orders?type=all',
            id: 'all_orders',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'warehouse.orders',
            url: 'orders-board',
            id: 'orders-board-warehouse',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'seller.orders',
            url: 'orders/seller',
            id: 'orders-list-seller',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'delivery.orders',
            url: 'orders-board/delivery',
            id: 'order-list-delivery',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'point.orders',
            url: 'orders-board/point',
            id: 'order-list-point',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'refunds',
            url: 'refunds',
            id: 'refunds_02',
            type: 'single',
            parentId: 'orders',
          },
        ],
      },
      {
        name: 'order.status',
        url: 'settings/orderStatus',
        id: 'order.status',
        icon: 'order_statuses',
        type: 'single',
      },
    ],
  },
  {
    name: 'booking.management',
    id: 'booking_management',
    type: 'group',
    menus: [
      {
        name: 'bookings',
        url: 'booking',
        id: 'bookings',
        icon: 'clock',
        type: 'single',
      },
    ],
  },
  {
    name: 'zone.management',
    id: 'zone_management',
    type: 'group',
    menus: [
      {
        name: 'region',
        icon: 'delivery',
        id: 'region',
        url: 'deliveryzone/region',
        type: 'single',
      },
      {
        name: 'country',
        icon: 'delivery',
        id: 'country',
        url: 'deliveryzone/country',
        type: 'single',
      },
      {
        name: 'city',
        icon: 'delivery',
        id: 'city',
        url: 'deliveryzone/city',
        type: 'single',
      },
      {
        name: 'area',
        icon: 'delivery',
        id: 'area',
        url: 'deliveryzone/area',
        type: 'single',
      },
    ],
  },
  {
    name: 'delivery.management',
    id: 'deliveryman_management',
    icon: 'delivery',
    type: 'group',
    menus: [
      {
        name: 'delivery.point',
        icon: 'delivery',
        url: 'delivery-point',
        id: 'delivery.point',
        type: 'single',
      },
      {
        name: 'delivery.price',
        icon: 'delivery',
        url: 'delivery-price',
        id: 'delivery.price',
        type: 'single',
      },
      {
        name: 'deliveries.list',
        icon: 'TbTruckDelivery',
        id: 'deliveries_list',
        url: 'deliveries/list',
        type: 'single',
      },
      {
        name: 'deliveries.map',
        icon: 'TbSitemap',
        id: 'deliveries_map',
        url: 'deliveries/map',
        type: 'single',
      },
      {
        name: 'delivery.statistics',
        icon: 'ImStatsDots',
        id: 'delivery_statistics',
        url: 'delivery/statistics',
        type: 'single',
      },
      {
        name: 'deliveryboy.reviews',
        icon: 'TbTruckDelivery',
        url: 'reviews/deliveryboy',
        id: 'deliveryboy_reviews_01',
        type: 'single',
      },
      {
        name: 'deliveryman.request',
        icon: 'QuestionCircleOutlined',
        url: 'deliveryman/request',
        id: 'deliveryman_request_01',
        type: 'single',
      },
    ],
  },
  {
    name: 'shop.management',
    id: 'shop_management',
    icon: 'shop',
    type: 'group',
    menus: [
      {
        name: 'shops',
        icon: 'shop',
        url: 'shops',
        id: 'shops',
        type: 'single',
      },
      {
        name: 'shop.tag',
        icon: 'shop',
        url: 'shop-tag',
        id: 'tag',
        type: 'single',
      },
      {
        name: 'shop.reviews',
        icon: 'star',
        url: 'shop-reviews',
        id: 'shop_review_01',
        type: 'single',
      },
    ],
  },
  {
    name: 'service.management',
    id: 'services_management',
    type: 'group',
    menus: [
      {
        name: 'services',
        id: 'services',
        icon: 'service',
        url: 'services',
        type: 'single',
      },
      {
        name: 'service.categories',
        icon: 'appStore',
        url: 'catalog/service-categories',
        id: 'service-categories',
        type: 'single',
      },
      {
        name: 'service.extra',
        icon: 'appStoreAdd',
        url: 'service-extra',
        id: 'service-extra',
        type: 'single',
      },
      {
        name: 'service.notifications',
        icon: 'bell',
        url: 'service-notifications',
        id: 'service-notifications',
        type: 'single',
      },
    ],
  },
  {
    name: 'product.management',
    id: 'product_management',
    icon: 'branches',
    type: 'group',
    menus: [
      {
        name: 'products',
        icon: 'dropbox',
        url: 'catalog/products',
        id: 'food',
        type: 'single',
      },
      {
        name: 'looks',
        icon: 'looks',
        url: 'catalog/looks',
        id: 'admin_looks',
        type: 'single',
      },
      {
        name: 'extras',
        icon: 'branches',
        id: 'extras',
        type: 'parent',
        children: [
          {
            name: 'extra.group',
            url: 'catalog/extras',
            id: 'extra.group',
            parentId: 'extras',
            type: 'single',
          },
          {
            name: 'extra.value',
            url: 'catalog/extras/value',
            id: 'extra.value',
            parentId: 'extras',
            type: 'single',
          },
        ],
      },
      {
        name: 'properties',
        icon: 'branches',
        id: 'properties',
        type: 'parent',
        children: [
          {
            name: 'properties.group',
            url: 'catalog/properties',
            id: 'properties.group',
            parentId: 'properties',
            type: 'single',
          },
          {
            name: 'properties.value',
            url: 'catalog/properties/value',
            id: 'properties.value',
            parentId: 'properties',
            type: 'single',
          },
        ],
      },
      {
        name: 'categories',
        icon: 'appStore',
        url: 'catalog/categories',
        id: 'categories',
        type: 'single',
      },
      {
        name: 'product.reviews',
        icon: 'skin',
        url: 'reviews/product',
        id: 'product-review',
        type: 'single',
      },
    ],
  },
  {
    name: 'content.management',
    id: 'content_management',
    type: 'group',
    menus: [
      {
        name: 'brands',
        icon: 'appStoreAdd',
        url: 'catalog/brands',
        id: 'brands',
        type: 'single',
      },
      {
        name: 'career',
        icon: 'CaretUpOutlined',
        url: 'careers/list',
        id: 'career_list',
        type: 'parent',
        children: [
          {
            name: 'career',
            icon: 'caretUp',
            url: 'catalog/career',
            id: 'catalog_career',
            type: 'single',
          },
          {
            name: 'career.categories',
            icon: 'careerCategory',
            url: 'catalog/career-categories',
            id: 'career_categories',
            type: 'single',
          },
        ],
      },
      {
        name: 'units',
        icon: 'disconnect',
        url: 'catalog/units',
        id: 'units',
        type: 'single',
      },
      {
        name: 'banners',
        icon: 'bsImage',
        url: 'banners',
        id: 'banners_02',
        type: 'single',
      },
      {
        name: 'blogs',
        url: 'blogs',
        icon: 'form',
        id: 'blogs_02',
        type: 'single',
      },
      {
        name: 'stories',
        icon: 'BsClockHistory',
        url: 'stories',
        id: 'stories_02',
        type: 'single',
      },
      {
        name: 'gallery',
        url: 'gallery',
        icon: 'fiImage',
        id: 'gallery_02',
        type: 'single',
      },
      {
        name: 'notifications',
        icon: 'notificationsActive',
        url: 'notifications',
        id: 'notifications_02',
        type: 'single',
      },
      {
        name: 'form.options',
        icon: 'forms',
        url: 'form-options',
        id: 'form_options_02',
        type: 'single',
      },
    ],
  },
  {
    name: 'ads.management',
    id: 'advert.management',
    type: 'group',
    menus: [
      {
        name: 'ads',
        id: 'ads',
        url: 'catalog/advert',
        icon: 'appStore',
        type: 'single',
      },
      {
        name: 'shop.ads',
        id: 'shop_ads',
        url: 'catalog/shop-ads',
        icon: 'appStore',
        type: 'single',
      },
    ],
  },
  {
    name: 'user.management',
    id: 'customer_management',
    type: 'group',
    menus: [
      {
        name: 'wallets',
        icon: 'wallet',
        url: 'wallets',
        id: 'wallets_01',
        type: 'single',
      },
      {
        name: 'payment.to.sellers',
        icon: 'moneyOut',
        id: 'withdraws',
        type: 'parent',
        children: [
          {
            name: 'payment.to.sellers',
            url: 'withdraws/seller',
            id: 'withdraws.seller_uncomplete',
            type: 'single',
            parentId: 'withdraws',
          },
          {
            name: 'completed.payments',
            url: 'completed-withdraws/seller',
            id: 'withdraws.completed_seller_uncomplete',
            type: 'single',
            parentId: 'withdraws',
          },
        ],
      },
      {
        name: 'payment.to.drivers',
        id: 'payment_to_drivers',
        icon: 'wallet',
        type: 'parent',
        children: [
          {
            name: 'payment.to.deliverymans',
            url: 'withdraws/deliveryman',
            id: 'withdraw.deliverymans_uncomplete',
            type: 'single',
            parentId: 'payment_to_drivers',
          },
          {
            name: 'completed.payments',
            url: 'completed-withdraws/deliveryman',
            id: 'withdraw.completed_deliverymans_uncomplete',
            type: 'single',
            parentId: 'payment_to_drivers',
          },
        ],
      },
      {
        name: 'customer',
        id: 'customer.management_02',
        icon: 'wallet',
        type: 'parent',
        children: [
          {
            name: 'clients',
            url: 'users/user',
            id: 'user',
            type: 'single',
            parentId: 'customer.management_02',
          },
          {
            name: 'users',
            url: 'users/admin',
            id: 'userGroupAdd',
            type: 'single',
            parentId: 'customer.management_02',
          },
          {
            name: 'roles',
            url: 'users/role',
            id: 'userSwitch',
            type: 'single',
            parentId: 'customer.management_02',
          },
        ],
      },
      {
        name: 'email.subscriber',
        icon: 'mail',
        id: 'email.subscriber_01',
        type: 'parent',
        children: [
          {
            name: 'subscriber',
            url: 'subscriber',
            id: 'subscriber',
            type: 'single',
            parentId: 'email.subscriber_01',
          },
          {
            name: 'message.subscriber',
            url: 'message/subscriber',
            id: 'message.subscriber',
            type: 'single',
            parentId: 'email.subscriber_01',
          },
        ],
      },
    ],
  },
  {
    name: 'transaction.management',
    id: 'transaction.management',
    type: 'group',
    menus: [
      {
        name: 'transactions',
        icon: 'transaction',
        url: 'transactions',
        id: 'transactions',
        type: 'single',
      },
      {
        name: 'payout.requests',
        icon: 'dollar',
        url: 'payout-requests',
        id: 'payout-requests',
        type: 'single',
      },
      {
        name: 'payouts',
        icon: 'moneyOut',
        url: 'payouts',
        id: 'admin.payouts',
        type: 'single',
      },
      {
        name: 'subscriptions',
        icon: 'imSubscript',
        url: 'subscriptions',
        id: 13,
        type: 'single',
      },
      {
        name: 'shop.subscriptions',
        icon: 'bell',
        url: 'shop-subscriptions',
        id: 14,
        type: 'single',
      },
    ],
  },
  {
    name: 'marketing.management',
    id: 'restaurant.management_05',
    type: 'group',
    menus: [
      {
        name: 'cashback',
        icon: 'copyright',
        url: 'cashback',
        id: 'cashback_01',
        type: 'single',
      },
      {
        name: 'referral',
        icon: 'referral',
        url: 'settings/referal',
        id: 'referral_02',
        type: 'single',
      },
      {
        name: 'bonus',
        icon: 'GiftOutlined',
        url: 'bonus/list',
        id: 'bonus_02',
        type: 'single',
      },
      {
        name: 'coupons',
        icon: 'calendar',
        url: 'coupons',
        id: 'coupons',
        type: 'single',
      },
      {
        name: 'membership',
        icon: 'userAdd',
        url: 'membership',
        id: 'membership',
        type: 'single',
      },
      {
        name: 'user.memberships',
        icon: 'idCart',
        url: 'user-memberships',
        id: 'user.memberships',
        type: 'single',
      },
      {
        name: 'gift.cards',
        icon: 'GiftOutlined',
        url: 'gift-cards',
        id: 'gift_cards',
        type: 'single',
      },
      {
        name: 'user.gift.cards',
        icon: 'GiftOutlined',
        url: 'user-gift-cards',
        id: 'user.gift.cards',
        type: 'single',
      },
    ],
  },
  {
    name: 'analytics.and.reports',
    id: 'analytics',
    type: 'group',
    menus: [
      {
        name: 'products',
        icon: 'products',
        url: 'report/products',
        id: 'report-products',
        type: 'single',
      },
      {
        name: 'order',
        icon: 'orders',
        url: 'report/orders',
        id: 'report-orders',
        type: 'single',
      },
      {
        name: 'stock',
        icon: 'stock',
        url: 'report/stock',
        id: 'report-stock',
        type: 'single',
      },
      {
        name: 'category',
        icon: 'categories',
        url: 'report/categories',
        id: 'report-categories',
        type: 'single',
      },
      {
        name: 'overview',
        icon: 'overview',
        url: 'report/overview',
        id: 'report-overview',
        type: 'single',
      },
      {
        name: 'revenue',
        icon: 'revenue',
        url: 'report/revenue',
        id: 'report-revenue',
        type: 'single',
      },
      {
        name: 'variation',
        icon: 'variation',
        url: 'report/extras',
        id: 'report-variation',
        type: 'single',
      },
    ],
  },
  {
    name: 'business.settings',
    id: 'business.settings_02',
    type: 'group',
    menus: [
      {
        name: 'settings.general',
        icon: 'settings',
        url: 'settings/general',
        id: 'settings.general_02',
        type: 'single',
      },
      {
        name: 'currencies',
        icon: 'moneyCollect',
        url: 'currencies',
        id: 'currencies',
        type: 'single',
      },
      {
        name: 'payments',
        icon: 'wallet',
        url: 'settings/payments',
        id: 'payments',
        type: 'single',
      },
      {
        name: 'payment.payloads',
        icon: 'payload',
        url: 'payment-payloads',
        id: 'payment.payloads',
        type: 'single',
      },
      {
        name: 'sms-payload',
        icon: 'message',
        url: 'settings/sms-payload',
        id: 'sms-payload',
        type: 'single',
      },
      {
        name: 'email.provider',
        icon: 'emailSettings',
        url: 'settings/emailProviders',
        id: 'settings_email.provider_02',
        type: 'single',
      },
      {
        name: 'notification.settings',
        icon: 'notificationsActive',
        url: 'settings/firebase',
        id: 'notification.settings',
        type: 'single',
      },
      {
        name: 'social.settings',
        icon: 'instagram',
        url: 'settings/social',
        id: 'instagram_social-settings_01',
        type: 'single',
      },
      {
        name: 'app.settings',
        icon: 'GrAppleAppStore',
        url: 'settings/app',
        id: 'app-settings',
        type: 'single',
      },
      {
        name: 'page.setup',
        icon: 'settings',
        id: 'page.setup',
        type: 'parent',
        children: [
          {
            name: 'faq',
            url: 'settings/faqs',
            id: 'faq',
            type: 'single',
            parentId: 'page.setup',
          },
          {
            name: 'terms',
            url: 'settings/terms',
            id: 'terms',
            type: 'single',
            parentId: 'page.setup',
          },
          {
            name: 'policy',
            url: 'settings/policy',
            id: 'policy',
            type: 'single',
            parentId: 'page.setup',
          },
          {
            name: 'pages',
            url: 'pages',
            id: 'pages',
            type: 'single',
            parentId: 'page.setup',
          },
          {
            name: 'landing.page',
            url: 'settings/landing-page',
            id: 'settings/landing-page',
            type: 'single',
            parentId: 'page.setup',
          },
        ],
      },
    ],
  },
  {
    name: 'system.settings',
    id: 'system.settings_01',
    type: 'group',
    menus: [
      {
        name: 'languages',
        icon: 'global',
        url: 'settings/languages',
        id: 'languages_02',
        type: 'single',
      },
      {
        name: 'translations',
        icon: 'translation',
        url: 'settings/translations',
        id: 'translations_01',
        type: 'single',
      },
      {
        icon: 'database',
        url: 'settings/backup',
        name: 'backup',
        id: 'backup_01',
        type: 'single',
      },
      {
        name: 'system.information',
        icon: 'tool',
        url: 'settings/system-information',
        id: 'settings/system-informations_tool_01',
        type: 'single',
      },
      {
        name: 'update',
        icon: 'cloudUpload',
        url: 'settings/update',
        id: 'update',
        type: 'single',
      },
      // {
      //   icon: 'cloudUpload',
      //   url: 'settings/bookingUpload',
      //   name: 'bookingUpload',
      //   id: 'bookingUpload',
      //   children: [],
      // },
      {
        icon: 'AiOutlineClear',
        url: 'settings/cashClear',
        name: 'clear.cash',
        id: 'clear_cash_02',
        type: 'single',
      },
    ],
  },
];

const managerRoutes = [
  {
    name: 'dashboard',
    icon: 'dashboard',
    url: 'dashboard',
    id: 'dashboard',
    type: 'single',
  },
  {
    name: 'calendar',
    icon: 'calendar',
    url: 'calendar',
    id: 'calendar',
    type: 'single',
  },
  {
    name: 'pos',
    icon: 'pos',
    url: 'pos-system',
    id: 'pos',
    type: 'single',
  },
  {
    name: 'warehouse',
    icon: 'warehouse',
    url: 'warehouse',
    id: 'warehouse',
    type: 'single',
  },
  {
    name: 'order.management',
    id: 'order_management',
    type: 'group',
    menus: [
      {
        name: 'orders',
        id: 'orders',
        icon: 'orders',
        type: 'parent',
        children: [
          {
            name: 'all',
            url: 'orders?type=all',
            id: 'all_orders',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'warehouse.orders',
            url: 'orders-board',
            id: 'orders-board-warehouse',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'seller.orders',
            url: 'orders/seller',
            id: 'orders-list-seller',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'delivery.orders',
            url: 'orders-board/delivery',
            id: 'order-list-delivery',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'point.orders',
            url: 'orders-board/point',
            id: 'order-list-point',
            type: 'single',
            parentId: 'orders',
          },
          {
            name: 'refunds',
            url: 'refunds',
            id: 'refunds_02',
            type: 'single',
            parentId: 'orders',
          },
        ],
      },
      {
        name: 'order.status',
        url: 'settings/orderStatus',
        id: 'order.status',
        icon: 'order_statuses',
        type: 'single',
      },
    ],
  },
  {
    name: 'booking.management',
    id: 'booking_management',
    type: 'group',
    menus: [
      {
        name: 'bookings',
        url: 'booking',
        id: 'bookings',
        icon: 'clock',
        type: 'single',
      },
    ],
  },
  {
    name: 'zone.management',
    id: 'zone_management',
    type: 'group',
    menus: [
      {
        name: 'region',
        icon: 'delivery',
        id: 'region',
        url: 'deliveryzone/region',
        type: 'single',
      },
      {
        name: 'country',
        icon: 'delivery',
        id: 'country',
        url: 'deliveryzone/country',
        type: 'single',
      },
      {
        name: 'city',
        icon: 'delivery',
        id: 'city',
        url: 'deliveryzone/city',
        type: 'single',
      },
      {
        name: 'area',
        icon: 'delivery',
        id: 'area',
        url: 'deliveryzone/area',
        type: 'single',
      },
    ],
  },
  {
    name: 'deliveryman',
    id: 'deliveryman_management',
    icon: 'delivery',
    type: 'group',
    menus: [
      {
        name: 'delivery.point',
        icon: 'delivery',
        url: 'delivery-point',
        id: 'delivery.point',
        type: 'single',
      },
      {
        name: 'delivery.price',
        icon: 'delivery',
        url: 'delivery-price',
        id: 'delivery.price',
        type: 'single',
      },
      {
        name: 'deliveries.list',
        icon: 'TbTruckDelivery',
        id: 'deliveries_list',
        url: 'deliveries/list',
        type: 'single',
      },
      {
        name: 'deliveries.map',
        icon: 'TbSitemap',
        id: 'deliveries_map',
        url: 'deliveries/map',
        type: 'single',
      },
      {
        name: 'delivery.statistics',
        icon: 'ImStatsDots',
        id: 'delivery_statistics',
        url: 'delivery/statistics',
        type: 'single',
      },
      {
        name: 'deliveryboy.reviews',
        icon: 'TbTruckDelivery',
        url: 'reviews/deliveryboy',
        id: 'deliveryboy_reviews_01',
        type: 'single',
      },
      {
        name: 'deliveryman.request',
        icon: 'QuestionCircleOutlined',
        url: 'deliveryman/request',
        id: 'deliveryman_request_01',
        type: 'single',
      },
    ],
  },
  {
    name: 'shop.management',
    id: 'shop_management',
    icon: 'shop',
    type: 'group',
    menus: [
      {
        name: 'shops',
        icon: 'shop',
        url: 'shops',
        id: 'shops',
        type: 'single',
      },
      {
        name: 'shop.tag',
        icon: 'shop',
        url: 'shop-tag',
        id: 'tag',
        type: 'single',
      },
      {
        name: 'shop.reviews',
        icon: 'star',
        url: 'shop-reviews',
        id: 'shop_review_01',
        type: 'single',
      },
    ],
  },
  {
    name: 'service.management',
    id: 'services_management',
    type: 'group',
    menus: [
      {
        name: 'services',
        id: 'services',
        icon: 'service',
        url: 'services',
        type: 'single',
      },
      {
        name: 'service.categories',
        icon: 'appStore',
        url: 'catalog/service-categories',
        id: 'service-categories',
        type: 'single',
      },
      {
        name: 'service.extra',
        icon: 'appStoreAdd',
        url: 'service-extra',
        id: 'service-extra',
        type: 'single',
      },
      {
        name: 'service.notifications',
        icon: 'bell',
        url: 'service-notifications',
        id: 'service-notifications',
        type: 'single',
      },
    ],
  },
  {
    name: 'product.management',
    id: 'product_management',
    icon: 'branches',
    type: 'group',
    menus: [
      {
        name: 'products',
        icon: 'dropbox',
        url: 'catalog/products',
        id: 'food',
        type: 'single',
      },
      {
        name: 'looks',
        icon: 'looks',
        url: 'catalog/looks',
        id: 'admin_looks',
        type: 'single',
      },
      {
        name: 'extras',
        icon: 'branches',
        id: 'extras',
        type: 'parent',
        children: [
          {
            name: 'extra.group',
            url: 'catalog/extras',
            id: 'extra.group',
            parentId: 'extras',
            type: 'single',
          },
          {
            name: 'extra.value',
            url: 'catalog/extras/value',
            id: 'extra.value',
            parentId: 'extras',
            type: 'single',
          },
        ],
      },
      {
        name: 'properties',
        icon: 'branches',
        id: 'properties',
        type: 'parent',
        children: [
          {
            name: 'properties.group',
            url: 'catalog/properties',
            id: 'properties.group',
            parentId: 'properties',
            type: 'single',
          },
          {
            name: 'properties.value',
            url: 'catalog/properties/value',
            id: 'properties.value',
            parentId: 'properties',
            type: 'single',
          },
        ],
      },
      {
        name: 'categories',
        icon: 'appStore',
        url: 'catalog/categories',
        id: 'categories',
        type: 'single',
      },
      {
        name: 'product.reviews',
        icon: 'skin',
        url: 'reviews/product',
        id: 'product-review',
        type: 'single',
      },
    ],
  },
  {
    name: 'content.management',
    id: 'content_management',
    type: 'group',
    menus: [
      {
        name: 'brands',
        icon: 'appStoreAdd',
        url: 'catalog/brands',
        id: 'brands',
        type: 'single',
      },
      {
        name: 'career',
        icon: 'CaretUpOutlined',
        url: 'careers/list',
        id: 'career_list',
        type: 'parent',
        children: [
          {
            name: 'career',
            icon: 'caretUp',
            url: 'catalog/career',
            id: 'catalog_career',
            type: 'single',
          },
          {
            name: 'career.categories',
            icon: 'careerCategory',
            url: 'catalog/career-categories',
            id: 'career_categories',
            type: 'single',
          },
        ],
      },
      {
        name: 'units',
        icon: 'disconnect',
        url: 'catalog/units',
        id: 'units',
        type: 'single',
      },
      {
        name: 'banners',
        icon: 'bsImage',
        url: 'banners',
        id: 'banners_02',
        type: 'single',
      },
      {
        name: 'blogs',
        url: 'blogs',
        icon: 'form',
        id: 'blogs_02',
        type: 'single',
      },
      {
        name: 'stories',
        icon: 'BsClockHistory',
        url: 'stories',
        id: 'stories_02',
        type: 'single',
      },
      {
        name: 'gallery',
        url: 'gallery',
        icon: 'fiImage',
        id: 'gallery_02',
        type: 'single',
      },
      {
        name: 'notifications',
        icon: 'notificationsActive',
        url: 'notifications',
        id: 'notifications_02',
        type: 'single',
      },
      {
        name: 'form.options',
        icon: 'forms',
        url: 'form-options',
        id: 'form_options_02',
        type: 'single',
      },
    ],
  },
  {
    name: 'ads.management',
    id: 'advert.management',
    type: 'group',
    menus: [
      {
        name: 'ads',
        id: 'ads',
        url: 'catalog/advert',
        icon: 'appStore',
        type: 'single',
      },
      {
        name: 'shop.ads',
        id: 'shop_ads',
        url: 'catalog/shop-ads',
        icon: 'appStore',
        type: 'single',
      },
    ],
  },
  {
    name: 'customer.management',
    id: 'customer_management',
    type: 'group',
    menus: [
      {
        name: 'wallets',
        icon: 'wallet',
        url: 'wallets',
        id: 'wallets_01',
        type: 'single',
      },
      {
        name: 'payment.to.sellers',
        icon: 'moneyOut',
        id: 'withdraws',
        type: 'parent',
        children: [
          {
            name: 'payment.to.sellers',
            url: 'withdraws/seller',
            id: 'withdraws.seller_uncomplete',
            type: 'single',
            parentId: 'withdraws',
          },
          {
            name: 'completed.payments',
            url: 'completed-withdraws/seller',
            id: 'withdraws.completed_seller_uncomplete',
            type: 'single',
            parentId: 'withdraws',
          },
        ],
      },
      {
        name: 'payment.to.drivers',
        id: 'payment_to_drivers',
        icon: 'wallet',
        type: 'parent',
        children: [
          {
            name: 'payment.to.deliverymans',
            url: 'withdraws/deliveryman',
            id: 'withdraw.deliverymans_uncomplete',
            type: 'single',
            parentId: 'payment_to_drivers',
          },
          {
            name: 'completed.payments',
            url: 'completed-withdraws/deliveryman',
            id: 'withdraw.completed_deliverymans_uncomplete',
            type: 'single',
            parentId: 'payment_to_drivers',
          },
        ],
      },
      {
        name: 'customer',
        id: 'customer.management_02',
        icon: 'wallet',
        type: 'parent',
        children: [
          {
            name: 'clients',
            url: 'users/user',
            id: 'user',
            type: 'single',
            parentId: 'customer.management_02',
          },
          {
            name: 'users',
            url: 'users/admin',
            id: 'userGroupAdd',
            type: 'single',
            parentId: 'customer.management_02',
          },
          {
            name: 'roles',
            url: 'users/role',
            id: 'userSwitch',
            type: 'single',
            parentId: 'customer.management_02',
          },
        ],
      },
      {
        name: 'email.subscriber',
        icon: 'mail',
        id: 'email.subscriber_01',
        type: 'parent',
        children: [
          {
            name: 'subscriber',
            url: 'subscriber',
            id: 'subscriber',
            type: 'single',
            parentId: 'email.subscriber_01',
          },
          {
            name: 'message.subscriber',
            url: 'message/subscriber',
            id: 'message.subscriber',
            type: 'single',
            parentId: 'email.subscriber_01',
          },
        ],
      },
    ],
  },
  {
    name: 'transaction.management',
    id: 'transaction.management',
    type: 'group',
    menus: [
      {
        name: 'transactions',
        icon: 'transaction',
        url: 'transactions',
        id: 'transactions',
        type: 'single',
      },
      {
        name: 'payout.requests',
        icon: 'dollar',
        url: 'payout-requests',
        id: 'payout-requests',
        type: 'single',
      },
      {
        name: 'payouts',
        icon: 'moneyOut',
        url: 'payouts',
        id: 'admin.payouts',
        type: 'single',
      },
      {
        name: 'subscriptions',
        icon: 'imSubscript',
        url: 'subscriptions',
        id: 13,
        type: 'single',
      },
      {
        name: 'shop.subscriptions',
        icon: 'bell',
        url: 'shop-subscriptions',
        id: 14,
        type: 'single',
      },
    ],
  },
  {
    name: 'marketing.management',
    id: 'restaurant.management_05',
    type: 'group',
    menus: [
      {
        name: 'cashback',
        icon: 'copyright',
        url: 'cashback',
        id: 'cashback_01',
        type: 'single',
      },
      {
        name: 'referral',
        icon: 'referral',
        url: 'settings/referal',
        id: 'referral_02',
        type: 'single',
      },
      {
        name: 'bonus',
        icon: 'GiftOutlined',
        url: 'bonus/list',
        id: 'bonus_02',
        type: 'single',
      },
      {
        name: 'coupons',
        icon: 'calendar',
        url: 'coupons',
        id: 'coupons',
        type: 'single',
      },
      {
        name: 'membership',
        icon: 'userAdd',
        url: 'membership',
        id: 'membership',
        type: 'single',
      },
      {
        name: 'user.memberships',
        icon: 'idCart',
        url: 'user-memberships',
        id: 'user.memberships',
        type: 'single',
      },
      {
        name: 'gift.cards',
        icon: 'GiftOutlined',
        url: 'gift-cards',
        id: 'gift_cards',
        type: 'single',
      },
      {
        name: 'user.gift.cards',
        icon: 'GiftOutlined',
        url: 'user-gift-cards',
        id: 'user.gift.cards',
        type: 'single',
      },
    ],
  },
  {
    name: 'analytics.and.reports',
    id: 'analytics',
    type: 'group',
    menus: [
      {
        name: 'products',
        icon: 'products',
        url: 'report/products',
        id: 'report-products',
        type: 'single',
      },
      {
        name: 'order',
        icon: 'orders',
        url: 'report/orders',
        id: 'report-orders',
        type: 'single',
      },
      {
        name: 'stock',
        icon: 'stock',
        url: 'report/stock',
        id: 'report-stock',
        type: 'single',
      },
      {
        name: 'category',
        icon: 'categories',
        url: 'report/categories',
        id: 'report-categories',
        type: 'single',
      },
      {
        name: 'overview',
        icon: 'overview',
        url: 'report/overview',
        id: 'report-overview',
        type: 'single',
      },
      {
        name: 'revenue',
        icon: 'revenue',
        url: 'report/revenue',
        id: 'report-revenue',
        type: 'single',
      },
      {
        name: 'variation',
        icon: 'variation',
        url: 'report/extras',
        id: 'report-variation',
        type: 'single',
      },
    ],
  },
  {
    name: 'business.settings',
    id: 'business.settings_02',
    type: 'group',
    menus: [
      {
        name: 'settings.general',
        icon: 'settings',
        url: 'settings/general',
        id: 'settings.general_02',
        type: 'single',
      },
      {
        name: 'currencies',
        icon: 'moneyCollect',
        url: 'currencies',
        id: 'currencies',
        type: 'single',
      },
      {
        name: 'payments',
        icon: 'wallet',
        url: 'settings/payments',
        id: 'payments',
        type: 'single',
      },
      {
        name: 'payment.payloads',
        icon: 'payload',
        url: 'payment-payloads',
        id: 'payment.payloads',
        type: 'single',
      },
      {
        name: 'sms-payload',
        icon: 'message',
        url: 'settings/sms-payload',
        id: 'sms-payload',
        type: 'single',
      },
      {
        name: 'email.provider',
        icon: 'emailSettings',
        url: 'settings/emailProviders',
        id: 'settings_email.provider_02',
        type: 'single',
      },
      {
        name: 'notification.settings',
        icon: 'notificationsActive',
        url: 'settings/firebase',
        id: 'notification.settings',
        type: 'single',
      },
      {
        name: 'social.settings',
        icon: 'instagram',
        url: 'settings/social',
        id: 'instagram_social-settings_01',
        type: 'single',
      },
      {
        name: 'app.settings',
        icon: 'GrAppleAppStore',
        url: 'settings/app',
        id: 'app-settings',
        type: 'single',
      },
      {
        name: 'page.setup',
        icon: 'settings',
        id: 'page.setup',
        type: 'parent',
        children: [
          {
            name: 'faq',
            url: 'settings/faqs',
            id: 'faq',
            type: 'single',
            parentId: 'page.setup',
          },
          {
            name: 'terms',
            url: 'settings/terms',
            id: 'terms',
            type: 'single',
            parentId: 'page.setup',
          },
          {
            name: 'policy',
            url: 'settings/policy',
            id: 'policy',
            type: 'single',
            parentId: 'page.setup',
          },
          {
            name: 'pages',
            url: 'pages',
            id: 'pages',
            type: 'single',
            parentId: 'page.setup',
          },
          {
            name: 'landing.page',
            url: 'settings/landing-page',
            id: 'settings/landing-page',
            type: 'single',
            parentId: 'page.setup',
          },
        ],
      },
    ],
  },
  {
    name: 'system.settings',
    id: 'system.settings_01',
    type: 'group',
    menus: [
      {
        name: 'languages',
        icon: 'global',
        url: 'settings/languages',
        id: 'languages_02',
        type: 'single',
      },
      {
        name: 'translations',
        icon: 'translation',
        url: 'settings/translations',
        id: 'translations_01',
        type: 'single',
      },
      {
        icon: 'database',
        url: 'settings/backup',
        name: 'backup',
        id: 'backup_01',
        type: 'single',
      },
      {
        name: 'system.information',
        icon: 'tool',
        url: 'settings/system-information',
        id: 'settings/system-informations_tool_01',
        type: 'single',
      },
      {
        name: 'update',
        icon: 'cloudUpload',
        url: 'settings/update',
        id: 'update',
        type: 'single',
      },
      // {
      //   icon: 'cloudUpload',
      //   url: 'settings/bookingUpload',
      //   name: 'bookingUpload',
      //   id: 'bookingUpload',
      //   children: [],
      // },
      {
        icon: 'AiOutlineClear',
        url: 'settings/cashClear',
        name: 'clear.cash',
        id: 'clear_cash_02',
        type: 'single',
      },
    ],
  },
];

const sellerRoutes = [
  {
    name: 'dashboard',
    icon: 'dashboard',
    url: 'dashboard',
    id: 'dashboard_03',
    type: 'single',
    role: 'admin',
  },
  {
    name: 'calendar',
    icon: 'calendar',
    url: 'seller/calendar',
    id: 'calendar',
    type: 'single',
  },
  {
    name: 'pos.system',
    icon: 'laptop',
    url: 'seller/pos-system',
    id: 'pos-system',
    type: 'single',
  },
  {
    name: 'wallet',
    id: 'wallet',
    icon: 'wallet',
    url: 'seller/wallet',
    type: 'single',
  },
  {
    name: 'delivery.price',
    icon: 'delivery',
    url: 'seller/delivery-price',
    id: 'seller.delivery.price',
    type: 'single',
  },
  {
    name: 'invitation.management',
    id: 'seller.master-invitations',
    type: 'group',
    menus: [
      {
        name: 'masters',
        id: 'seller_masters_ master-invitations',
        icon: 'user',
        url: 'seller/invitations/masters',
        type: 'single',
      },
      {
        name: 'deliverymen',
        id: 'seller_deliverymen_ master-invitations',
        icon: 'user',
        url: 'seller/invitations/deliverymen',
        type: 'single',
      },
    ],
  },
  {
    name: 'order.management',
    id: 'order_management',
    type: 'group',
    menus: [
      {
        name: 'all.orders',
        icon: 'fiShoppingCart',
        url: 'seller/orders-board',
        id: 'orders-board',
        type: 'single',
      },
      {
        name: 'refunds',
        icon: 'TbReceiptRefund',
        url: 'seller/refunds',
        id: 'refunds_01',
        type: 'single',
      },
    ],
  },
  {
    name: 'booking.management',
    id: 'seller-bookings',
    type: 'group',
    menus: [
      {
        name: 'bookings',
        id: 'seller-bookings',
        icon: 'clock',
        url: 'seller/bookings',
        type: 'single',
      },
      {
        name: 'bookings-report',
        id: 'seller-bookings-report',
        icon: 'revenue',
        url: 'seller/bookings-report',
        type: 'single',
      },
    ],
  },
  {
    name: 'shop.management',
    id: 'restaurants_management',
    type: 'group',
    menus: [
      {
        name: 'my.shop',
        icon: 'shop',
        url: 'my-shop',
        id: 'my-shop',
        type: 'single',
      },
      {
        name: 'shop.review',
        icon: 'star',
        url: 'seller/shop-reviews',
        id: 'shop-reviews',
        type: 'single',
      },
      // {
      //   name: 'branch',
      //   icon: 'branchesOutlined',
      //   url: 'seller/branch',
      //   id: 'branch',
      //   children: [],
      // },
      {
        name: 'users',
        icon: 'user',
        url: 'seller/shop-users',
        id: 'users',
        type: 'single',
      },
      // {
      //   name: 'deliverymen',
      //   icon: 'user',
      //   url: 'seller/deliverymen',
      //   id: 'deliverymen',
      //   children: [],
      // },
    ],
  },
  {
    name: 'service.management',
    id: 'seller.services.management',
    type: 'group',
    menus: [
      {
        name: 'services',
        id: 'seller_services',
        icon: 'service',
        url: 'seller/services',
        type: 'single',
      },
      {
        name: 'service.notifications',
        id: 'service_notifications',
        icon: 'bell',
        url: 'seller/service-notifications',
        type: 'single',
      },
      {
        name: 'service.master',
        icon: 'scissors',
        url: 'seller/service-master',
        id: 'service-master',
        type: 'single',
      },
    ],
  },
  {
    name: 'product.management',
    id: 'food_management',
    type: 'group',
    menus: [
      // {
      //   icon: 'SlPuzzle',
      //   url: 'seller/addons',
      //   name: 'addons',
      //   id: 'addons',
      //   children: [],
      // },
      // {
      //   name: 'recepts',
      //   icon: 'recept',
      //   url: 'seller/recept',
      //   id: 'recept',
      //   children: [],
      // },
      {
        name: 'discounts',
        icon: 'euroCircle',
        url: 'seller/discounts',
        id: 'discounts',
        type: 'single',
      },
      {
        icon: 'dropbox',
        url: 'seller/products',
        name: 'product',
        id: 'dropbox',
        type: 'single',
      },
      {
        name: 'product.categories',
        icon: 'appStore',
        url: 'seller/categories',
        id: 'categories',
        type: 'single',
      },
      {
        name: 'looks',
        icon: 'looks',
        url: 'seller/looks',
        id: 'seller_looks',
        type: 'single',
      },
      // {
      //   name: 'recipe.categories',
      //   icon: 'appStore',
      //   url: 'seller/recipe-categories',
      //   id: 'recipe.categories',
      //   children: [],
      // },
      {
        icon: 'branches',
        url: 'extras',
        name: 'extra.group',
        id: 'branches',
        type: 'single',
      },
      {
        icon: 'branches',
        url: 'extras/value',
        name: 'extra.value',
        id: 'extra_value',
        type: 'single',
      },
      {
        icon: 'branches',
        url: 'property',
        name: 'property.group',
        id: 'property',
        type: 'single',
      },
      {
        icon: 'branches',
        url: 'property/value',
        name: 'property.value',
        id: 'property_value',
        type: 'single',
      },
      {
        name: 'product.reviews',
        icon: 'skin',
        url: 'seller/reviews/product',
        id: 'product-review',
        type: 'single',
      },
    ],
  },
  {
    name: 'marketing.management',
    id: 'restaurant_management_03',
    type: 'group',
    menus: [
      {
        name: 'coupons',
        icon: 'calendar',
        url: 'seller/coupons',
        id: 'coupons',
        type: 'single',
      },
      // {
      //   icon: 'GiftOutlined',
      //   name: 'shop.bonus',
      //   url: 'seller/bonus/shop',
      //   id: 'bonus_shop',
      //   children: [],
      // },
      {
        icon: 'GiftOutlined',
        name: 'product.bonus',
        url: 'seller/bonus/product',
        id: 'bonus_product',
        type: 'single',
      },
      {
        name: 'gift.cards',
        icon: 'gift',
        url: 'seller/gift-cards',
        id: 'seller.gift.cards',
        type: 'single',
      },
      {
        name: 'membership',
        icon: 'userAdd',
        url: 'seller/membership',
        id: 'seller.membership',
        type: 'single',
      },
      {
        name: 'user.memberships',
        icon: 'idCart',
        url: 'seller/user-memberships',
        id: 'user.memberships',
        type: 'single',
      },
    ],
  },
  {
    name: 'analytics.and.reports',
    id: 'analytics',
    type: 'group',
    menus: [
      {
        name: 'order',
        icon: 'orders',
        url: 'seller/report/orders',
        id: 'report-orders',
        type: 'single',
      },
    ],
  },
  {
    name: 'transaction',
    id: 'transaction_management',
    type: 'group',
    menus: [
      {
        name: 'payments',
        icon: 'wallet',
        url: 'seller/payments',
        id: 'payments',
        type: 'single',
      },
      {
        name: 'transactions',
        icon: 'transaction',
        url: 'seller/transactions',
        id: 'transactions',
        type: 'single',
      },
      {
        name: 'payment.from.admin',
        icon: 'moneyOut',
        url: 'seller/withdraws',
        id: 'withdraws',
        type: 'single',
      },
      {
        name: 'payouts',
        icon: 'dollar',
        url: 'seller/payouts',
        id: 'payouts',
        type: 'single',
      },
    ],
  },
  {
    name: 'business',
    id: 'business_management',
    type: 'group',
    menus: [
      {
        name: 'subscriptions',
        icon: 'trophy',
        url: 'seller/subscriptions',
        id: 'subscription',
        type: 'single',
      },
      {
        name: 'my.subscriptions',
        icon: 'trophy',
        url: 'seller/my-subscriptions',
        id: 'my-subscriptions',
        type: 'single',
      },
      {
        name: 'ad.packages',
        id: 'ad_packages',
        url: 'seller/advert',
        icon: 'MdOutlineTableBar',
        type: 'single',
      },
      {
        name: 'ads',
        id: 'shop_ads',
        url: 'seller/shop-ads',
        icon: 'appStore',
        type: 'single',
      },
    ],
  },
  {
    name: 'content',
    id: 'content_management',
    type: 'group',
    menus: [
      {
        name: 'stories',
        icon: 'BsClockHistory',
        url: 'seller/stories',
        id: 'seller_stories',
        type: 'single',
      },
      {
        name: 'brands',
        icon: 'appStoreAdd',
        url: 'seller/brands',
        id: 'brands',
        type: 'single',
      },
      {
        name: 'form.options',
        icon: 'forms',
        url: 'seller/form-options',
        id: 'form.options',
        type: 'single',
      },
    ],
  },
  {
    name: 'logout',
    icon: 'logout',
    url: '',
    id: 'logout_01',
  },
];

const moderatorRoutes = [
  {
    name: 'dashboard',
    icon: 'dashboard',
    url: 'dashboard',
    id: 'dashboard_03',
    type: 'single',
    role: 'admin',
  },
  {
    name: 'calendar',
    icon: 'calendar',
    url: 'seller/calendar',
    id: 'calendar',
    type: 'single',
  },
  {
    name: 'pos.system',
    icon: 'laptop',
    url: 'seller/pos-system',
    id: 'pos-system',
    type: 'single',
  },
  {
    name: 'wallet',
    id: 'wallet',
    icon: 'wallet',
    url: 'seller/wallet',
    type: 'single',
  },
  {
    name: 'delivery.price',
    icon: 'delivery',
    url: 'seller/delivery-price',
    id: 'seller.delivery.price',
    type: 'single',
  },
  {
    name: 'invitation.management',
    id: 'seller.master-invitations',
    type: 'group',
    menus: [
      {
        name: 'masters',
        id: 'seller_masters_ master-invitations',
        icon: 'user',
        url: 'seller/invitations/masters',
        type: 'single',
      },
      {
        name: 'deliverymen',
        id: 'seller_deliverymen_ master-invitations',
        icon: 'user',
        url: 'seller/invitations/deliverymen',
        type: 'single',
      },
    ],
  },
  {
    name: 'order.management',
    id: 'order_management',
    type: 'group',
    menus: [
      {
        name: 'all.orders',
        icon: 'fiShoppingCart',
        url: 'seller/orders-board',
        id: 'orders-board',
        type: 'single',
      },
      {
        name: 'refunds',
        icon: 'TbReceiptRefund',
        url: 'seller/refunds',
        id: 'refunds_01',
        type: 'single',
      },
    ],
  },
  {
    name: 'booking.management',
    id: 'seller-bookings',
    type: 'group',
    menus: [
      {
        name: 'bookings',
        id: 'seller-bookings',
        icon: 'clock',
        url: 'seller/bookings',
        type: 'single',
      },
      {
        name: 'bookings-report',
        id: 'seller-bookings-report',
        icon: 'revenue',
        url: 'seller/bookings-report',
        type: 'single',
      },
    ],
  },
  {
    name: 'shop.management',
    id: 'restaurants_management',
    type: 'group',
    menus: [
      {
        name: 'my.shop',
        icon: 'shop',
        url: 'my-shop',
        id: 'my-shop',
        type: 'single',
      },
      {
        name: 'shop.review',
        icon: 'star',
        url: 'seller/shop-reviews',
        id: 'shop-reviews',
        type: 'single',
      },
      // {
      //   name: 'branch',
      //   icon: 'branchesOutlined',
      //   url: 'seller/branch',
      //   id: 'branch',
      //   children: [],
      // },
      {
        name: 'users',
        icon: 'user',
        url: 'seller/shop-users',
        id: 'users',
        type: 'single',
      },
      // {
      //   name: 'deliverymen',
      //   icon: 'user',
      //   url: 'seller/deliverymen',
      //   id: 'deliverymen',
      //   children: [],
      // },
    ],
  },
  {
    name: 'service.management',
    id: 'seller.services.management',
    type: 'group',
    menus: [
      {
        name: 'services',
        id: 'seller_services',
        icon: 'service',
        url: 'seller/services',
        type: 'single',
      },
      {
        name: 'service.notifications',
        id: 'service_notifications',
        icon: 'bell',
        url: 'seller/service-notifications',
        type: 'single',
      },
      {
        name: 'service.master',
        icon: 'scissors',
        url: 'seller/service-master',
        id: 'service-master',
        type: 'single',
      },
    ],
  },
  {
    name: 'product.management',
    id: 'food_management',
    type: 'group',
    menus: [
      // {
      //   icon: 'SlPuzzle',
      //   url: 'seller/addons',
      //   name: 'addons',
      //   id: 'addons',
      //   children: [],
      // },
      // {
      //   name: 'recepts',
      //   icon: 'recept',
      //   url: 'seller/recept',
      //   id: 'recept',
      //   children: [],
      // },
      {
        name: 'discounts',
        icon: 'euroCircle',
        url: 'seller/discounts',
        id: 'discounts',
        type: 'single',
      },
      {
        icon: 'dropbox',
        url: 'seller/products',
        name: 'product',
        id: 'dropbox',
        type: 'single',
      },
      {
        name: 'product.categories',
        icon: 'appStore',
        url: 'seller/categories',
        id: 'categories',
        type: 'single',
      },
      {
        name: 'looks',
        icon: 'looks',
        url: 'seller/looks',
        id: 'seller_looks',
        type: 'single',
      },
      // {
      //   name: 'recipe.categories',
      //   icon: 'appStore',
      //   url: 'seller/recipe-categories',
      //   id: 'recipe.categories',
      //   children: [],
      // },
      {
        icon: 'branches',
        url: 'extras',
        name: 'extra.group',
        id: 'branches',
        type: 'single',
      },
      {
        icon: 'branches',
        url: 'extras/value',
        name: 'extra.value',
        id: 'extra_value',
        type: 'single',
      },
      {
        icon: 'branches',
        url: 'property',
        name: 'property.group',
        id: 'property',
        type: 'single',
      },
      {
        icon: 'branches',
        url: 'property/value',
        name: 'property.value',
        id: 'property_value',
        type: 'single',
      },
      {
        name: 'product.reviews',
        icon: 'skin',
        url: 'seller/reviews/product',
        id: 'product-review',
        type: 'single',
      },
    ],
  },
  {
    name: 'marketing.management',
    id: 'restaurant_management_03',
    type: 'group',
    menus: [
      {
        name: 'coupons',
        icon: 'calendar',
        url: 'seller/coupons',
        id: 'coupons',
        type: 'single',
      },
      // {
      //   icon: 'GiftOutlined',
      //   name: 'shop.bonus',
      //   url: 'seller/bonus/shop',
      //   id: 'bonus_shop',
      //   children: [],
      // },
      {
        icon: 'GiftOutlined',
        name: 'product.bonus',
        url: 'seller/bonus/product',
        id: 'bonus_product',
        type: 'single',
      },
      {
        name: 'gift.cards',
        icon: 'gift',
        url: 'seller/gift-cards',
        id: 'seller.gift.cards',
        type: 'single',
      },
      {
        name: 'membership',
        icon: 'userAdd',
        url: 'seller/membership',
        id: 'seller.membership',
        type: 'single',
      },
      {
        name: 'user.memberships',
        icon: 'idCart',
        url: 'seller/user-memberships',
        id: 'user.memberships',
        type: 'single',
      },
    ],
  },
  {
    name: 'analytics.and.reports',
    id: 'analytics',
    type: 'group',
    menus: [
      {
        name: 'order',
        icon: 'orders',
        url: 'seller/report/orders',
        id: 'report-orders',
        type: 'single',
      },
    ],
  },
  {
    name: 'transaction',
    id: 'transaction_management',
    type: 'group',
    menus: [
      {
        name: 'payments',
        icon: 'wallet',
        url: 'seller/payments',
        id: 'payments',
        type: 'single',
      },
      {
        name: 'transactions',
        icon: 'transaction',
        url: 'seller/transactions',
        id: 'transactions',
        type: 'single',
      },
      {
        name: 'payment.from.admin',
        icon: 'moneyOut',
        url: 'seller/withdraws',
        id: 'withdraws',
        type: 'single',
      },
      {
        name: 'payouts',
        icon: 'dollar',
        url: 'seller/payouts',
        id: 'payouts',
        type: 'single',
      },
    ],
  },
  {
    name: 'business',
    id: 'business_management',
    type: 'group',
    menus: [
      {
        name: 'subscriptions',
        icon: 'trophy',
        url: 'seller/subscriptions',
        id: 'subscription',
        type: 'single',
      },
      {
        name: 'my.subscriptions',
        icon: 'trophy',
        url: 'seller/my-subscriptions',
        id: 'my-subscriptions',
        type: 'single',
      },
      {
        name: 'ad.packages',
        id: 'ad_packages',
        url: 'seller/advert',
        icon: 'MdOutlineTableBar',
        type: 'single',
      },
      {
        name: 'ads',
        id: 'shop_ads',
        url: 'seller/shop-ads',
        icon: 'appStore',
        type: 'single',
      },
    ],
  },
  {
    name: 'content',
    id: 'content_management',
    type: 'group',
    menus: [
      {
        name: 'stories',
        icon: 'BsClockHistory',
        url: 'seller/stories',
        id: 'seller_stories',
        type: 'single',
      },
      {
        name: 'brands',
        icon: 'appStoreAdd',
        url: 'seller/brands',
        id: 'brands',
        type: 'single',
      },
      {
        name: 'form.options',
        icon: 'forms',
        url: 'seller/form-options',
        id: 'form.options',
        type: 'single',
      },
    ],
  },
  {
    name: 'logout',
    icon: 'logout',
    url: '',
    id: 'logout_01',
  },
];

const deliverymanRoutes = [
  {
    name: 'dashboard',
    icon: 'dashboard',
    url: 'dashboard',
    id: 'dashboard',
    type: 'single',
  },
  {
    name: 'orders',
    icon: 'orders',
    url: 'deliveryman/orders',
    id: 'orders',
    type: 'single',
  },
  {
    name: 'payment.from.admin',
    icon: 'moneyOut',
    url: 'deliveryman/withdraws',
    id: 'withdraws',
    type: 'single',
  },
];

const waiterRoutes = [
  {
    name: 'my.orders',
    id: 'orders-board',
    icon: 'user',
    url: 'waiter/orders-board',
    type: 'single',
  },
  {
    name: 'all.orders',
    icon: 'fiShoppingCart',
    id: 'order_management',
    url: 'waiter/orders',
    type: 'single',
  },
];

const parcelRoutes = [
  {
    name: 'dashboard',
    icon: 'dashboard',
    url: 'dashboard',
    id: 'dashboard',
    type: 'single',
  },
  {
    name: 'parcel.order',
    id: 'parcel.order',
    icon: 'fiShoppingCart',
    type: 'group',
    menus: [
      {
        name: 'all.orders',
        icon: 'fiShoppingCart',
        url: 'parcel-orders',
        id: 'parcel-orders',
        type: 'single',
      },
      {
        name: 'parcel.types',
        icon: 'star',
        url: 'parcel-types',
        id: 'parcel-types',
        type: 'single',
      },
      {
        name: 'options',
        icon: 'branches',
        url: 'options',
        id: 'options',
        type: 'single',
      },
      {
        name: 'order.status',
        icon: 'RiFileSettingsLine',
        url: 'settings/orderStatus',
        id: 'order.status',
        type: 'single',
      },
    ],
  },
  {
    name: 'deliveryman',
    id: 'deliveryman.management',
    icon: 'CarOutlined',
    type: 'group',
    menus: [
      {
        name: 'deliveries.list',
        icon: 'TbTruckDelivery',
        id: 'deliveries_list',
        url: 'deliveries/list',
        type: 'single',
      },
      {
        name: 'deliveries.map',
        icon: 'TbSitemap',
        id: 'deliveries_map',
        url: 'deliveries/map',
        type: 'single',
      },
      {
        name: 'delivery.statistics',
        icon: 'ImStatsDots',
        id: 'delivery.statistics',
        url: 'delivery/statistics',
        type: 'single',
      },
      {
        name: 'deliveryboy.reviews',
        icon: 'TbTruckDelivery',
        url: 'reviews/deliveryboy',
        id: 'deliveryboy-reviews_01',
        type: 'single',
      },
    ],
  },
];

const masterRoutes = [
  {
    name: 'dashboard',
    icon: 'dashboard',
    url: 'dashboard',
    id: 'dashboard_05',
    type: 'single',
  },
  {
    name: 'calendar',
    icon: 'calendar',
    url: 'master/calendar',
    id: 'calendar',
    type: 'single',
  },
  {
    name: 'service.master',
    icon: 'scissors',
    url: 'master/service-master',
    id: 'service-master_05',
    type: 'single',
  },
  {
    name: 'closed.days',
    icon: 'clock',
    url: 'master/closed-days',
    id: 'master-closed-days_05',
    type: 'single',
  },
  {
    name: 'disabled.times',
    icon: 'businessTime',
    url: 'master/disabled-times',
    id: 'master-disabled-times_05',
    type: 'single',
  },
  {
    name: 'gallery',
    icon: 'gallery',
    url: 'master/gallery',
    id: 'master-gallery_05',
    type: 'single',
  },
  {
    name: 'form.options',
    icon: 'forms',
    url: 'master/form-options',
    id: 'form.options',
    type: 'single',
  },
  {
    name: 'service.notifications',
    icon: 'bell',
    url: 'master/service-notifications',
    id: 'service.notifications',
    type: 'single',
  },
];

export const data = {
  admin: adminRoutes,
  manager: managerRoutes,
  seller: sellerRoutes,
  moderator: moderatorRoutes,
  deliveryman: deliverymanRoutes,
  waiter: waiterRoutes,
  parcel: parcelRoutes,
  master: masterRoutes,
};
